/* EchoGals/Echo24 BeOS Driver for Echo audio cards
 * Copyright (c) 2003, Jerome Duval (jerome.duval@free.fr)
 * Original code : BeOS Driver for Intel ICH AC'97 Link interface
 * Copyright (c) 2002, Marcus Overhagen <marcus@overhagen.de> */

#ifndef _MULTI_H_
#define _MULTI_H_

#include "OsSupportBeOS.h"
#include "MixerXface.h"

typedef struct _multi_mixer_control {
	struct _multi_dev 	*multi;
	void	(*get) (void *card, MIXER_AUDIO_CHANNEL, int32 type, float *values);
	void	(*set) (void *card, MIXER_AUDIO_CHANNEL, int32 type, float *values);
	MIXER_AUDIO_CHANNEL 	channel;
	int32 type;
	multi_mix_control	mix_control;
} multi_mixer_control;

#define MULTI_CONTROL_FIRSTID	1024
#define MULTI_CONTROL_MASTERID	0

typedef struct _multi_dev {
	void	*card;
#define MULTICONTROLSNUM 128
	multi_mixer_control controls[MULTICONTROLSNUM];
	uint32 control_count;
	
#define MULTICHANNUM 128
	multi_channel_info chans[MULTICHANNUM];
	uint32 output_channel_count;
	uint32 input_channel_count;
	uint32 output_bus_channel_count;
	uint32 input_bus_channel_count;
	uint32 aux_bus_channel_count;
} multi_dev;

#endif
